/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button representing a node of resource explorer
 * @private
 */
Ext.define('Ametys.explorer.controllers.ImagesContainerController', {
	extend: 'Ametys.explorer.controllers.ExplorerNodeController',

	constructor: function(config)
	{
		this.callParent(arguments);
		
		Ametys.message.MessageBus.on(Ametys.message.Message.CREATED, this._onResourceCreated, this);
	},
	
	/**
	 * Listener when a resource has created
	 * Will update the state of the buttons upon the current selection.
	 * @param {Ametys.message.Message} message The created message.
	 * @private
	 */
	_onResourceCreated: function (message)
	{
		if (message.getTargets('resource').length > 0)
		{
			this.refresh();
		}
	},
	
	updateState: function()
	{
		this._getImages (this.getMatchingTargets()[0]);
	},
	
	/**
	 * Get the list of images associated to the given target
	 * @param target The matching target
	 * @private
	 */
	_getImages: function (target)
	{
		this.disable();
		this.serverCall ('getImages', [target.getParameters().id], this._getImagesCb, { refreshing: true });
	},
	
	/**
	 * @private
	 * Callback function called after retrieving the images of target
	 * @param params The JSON result 
	 */
	_getImagesCb: function (params)
	{
		this._images = params['images'];
		this._images.length == 0 ? this.disable() : this.enable();
	}
	
});
