/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button representing a node of resource explorer
 * @private
 */
Ext.define('Ametys.explorer.controllers.ResourcesViewController', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	/**
	 * @cfg {String} resource-collection-view (required) The view to set for the resource collection tool when the controlled button is pressed
	 */

	_initialize: function (config)
	{
		this.callParent(arguments);
		
		Ametys.message.MessageBus.on(Ametys.message.Message.TOOL_FOCUSED, this._onToolFocused, this);
		Ametys.message.MessageBus.on(Ametys.message.Message.TOOL_BLURRED, this._onToolBlurred, this);
		Ametys.message.MessageBus.on(Ametys.message.Message.TOOL_PARAMS_UPDATED, this._onToolParamsUpdated, this);
	},
	
	/**
	 * On tool focused listener
	 * @param {Ametys.message.Message} message The tool message
	 */
	_onToolFocused: function(message)
	{
		var toolTarget = this._getMatchingToolsTarget(message)[0];
		if (toolTarget)
		{
			var tool = toolTarget.getParameters().tool,
				currentView = tool.getParams().view,
				controllerView = this.getInitialConfig("resource-collection-view");
			
			this.toggle(currentView == controllerView);
		}
		else
		{
			this.toggle(false);
		}
	},
	
	/**
	 * On tool blurred listener
	 * @param {Ametys.message.Message} message The tool message
	 */
	_onToolBlurred: function(message)
	{
		var toolTarget = this._getMatchingToolsTarget(message)[0];
		if (toolTarget)
		{
			this.toggle(false);
		}
	},
	
	/**
	 * On tool params updated listener
	 * @param {Ametys.message.Message} message The tool message
	 */
	_onToolParamsUpdated: function(message)
	{
		var toolTarget = this._getMatchingToolsTarget(message)[0];
		if (toolTarget)
		{
			var tool = toolTarget.getParameters().tool;
			
			if (tool.hasFocus())
			{
				var currentView = tool.getParams().view,
					controllerView = this.getInitialConfig("resource-collection-view");
				
				this.toggle(currentView == controllerView);
			}
		}
	}
});
