/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the default model for nodes of an explorer tree.
 * See {@link Ametys.explorer.tree.ExplorerTree}
 */
Ext.define('Ametys.explorer.tree.ExplorerTree.NodeEntry', { 
	extend: 'Ext.data.Model',
	
	fields: [
		// Common properties
		{name: 'id', mapping: '@id'},
		{name: 'name', mapping: '@name'},
		{name: 'text', mapping: '@name', type: 'string'},
		{name: 'type', mapping: '@type', defaultValue: null},
		{name: 'path', mapping: '@path'},
		{name: 'remote', defaultValue: true},
		{name: 'allowDrag', type: 'boolean', calculate: function (data) { return data.isModifiable}},
		{
			name: 'allowDrop', 
			type: 'boolean', 
			calculate: function (data) { 
				return data.canCreateChild
			}
		},
		{
			name: 'leaf', 
			type: 'boolean', 
			convert: function (v, record) {
				return record.get('type') == 'resource' || record.get('type') == 'search' && v === true;
			}
		},
		
		{name: 'cls', mapping: '@cssClass', defaultValue: null},
		
		// Folder properties
		{name: 'applicationId', mapping: '@applicationId'},
		{name: 'hasResources', mapping: '@hasResources', type: 'boolean', defaultValue: false},
		{name: 'canCreateChild', mapping: '@canCreateChild', type: 'boolean', defaultValue: false},
		{name: 'hasChildNodes', mapping: '@hasChildNodes', type: 'boolean', defaultValue: false},
		{name: 'hasChild', type: 'boolean', calculate: function(data) { return data.hasChildNodes || data.hasResources;}},
		
		// File properties
		{name: 'mimetype', mapping: '@mimetype'},
		{name: 'lastModified', mapping: '@lastModified'},
		{name: 'size', mapping: '@size'},
		{name: 'author', mapping: '@author'},
		{name: 'isModifiable', mapping: '@isModifiable', type: 'boolean', defaultValue: false},
		{
			name: 'iconCls',
            mapping: '@iconCls',
			convert: function (v, record)
			{
                if (!v)
                {
                    if (record.get('type') == 'collection')
	                {
	                    return "a-tree-glyph ametysicon-folder249";
	                }
	                else
	                {
	                    return "a-tree-glyph " + Ametys.file.AbstractFileExplorerTree.getFileIconGlyph(record.get('name'));
	                }
                }
                else
                {
                    return "a-tree-glyph " + v;
                }
				
			}
		}
	]
});