/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for resource explorer file
 * @private
 */
Ext.define('Ametys.plugins.explorer.applications.resources.ResourcesApplication.ResourceEntry', {

	extend: 'Ext.data.Model',
	
	fields: [
				{name: 'id', mapping: '@id'},
				{name: 'name', mapping: '@name', type: 'string'},
				{name: 'author', mapping: '@author', type: 'string'},
				{name: 'path', mapping: '@path'},
				{name: 'keywords', mapping: '@keywords'},
				{name: 'size', mapping: '@size', type: 'float'}, 
				{name: 'lastModified', mapping: '@lastModified', type:'date', dateFormat:'c'},
				{name: 'isModifiable', mapping: '@isModifiable', type: 'boolean', defaultValue: false},
				{name: 'allowDrag', mapping: '@isModifiable', type: 'boolean', defaultValue: false},
				{name: 'isFile', defaultValue: true},
				
				// images view specific
				{
					name: 'shortName', 
					calculate: function(data) {
						return Ext.util.Format.ellipsis(data.name, 15);
					}
				},
				{
					name: 'sizeString', 
					calculate: function(data) {
						return Ext.util.Format.fileSize(data.size);
					}
				},
				{
					name: 'iconPath', 
					calculate: function(data) {
						var extension = "unknown";
						var index = data.name.lastIndexOf('.');
						if (index > 0)
						{
							extension = data.name.substring(index + 1).toLowerCase();
						}
						
						return Ametys.getPluginDirectPrefix('explorer') + '/icon/' + extension + '.png';
					}
				},
				{
					name: 'thumbnailPath', 
					calculate: function(data) {
						var thumbnailPath;
						var extension = "unknown";
						var index = data.name.lastIndexOf('.');
						if (index > 0)
						{
							extension = data.name.substring(index + 1).toLowerCase();
						}
						
						if (extension == 'jpg' || extension == 'jpeg' || extension == 'gif' || extension == 'png')
						{
							thumbnailPath = Ametys.getPluginDirectPrefix('explorer') + "/resource?id=" + data.id + "&maxWidth=100&maxHeight=100";
						}
						else
						{
							thumbnailPath = Ametys.getPluginDirectPrefix('explorer') + "/thumbnail/" + extension + ".png";
						}
						
						return thumbnailPath;
					}
				}
	]
});
