/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This factory creates Ametys.message.MessageTarget for a resource
 * @private
 */
Ext.define('Ametys.plugins.explorer.ExplorerNodeMessageTargetFactory', {
	extend: 'Ametys.message.factory.DefaultMessageTargetFactory',

	/**
	 * Create the targets for a message
	 * @param {Object} parameters The parameters needed by the factory to create the message. Can not be null. Handled elements are
	 * @param {String[]} parameters.ids The content's identifiers. Must be present if nodes is empty
	 * @param {Ametys.explorer.ExplorerNode[]} parameters.nodes The nodes themselves. Must be present if ids is empty
	 * @param {Function} callback The callback function called when the targets are created. Parameters are
	 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
	 */
	createTargets: function(parameters, callback)
	{
		var targets = [];
		
		if (parameters.ids)
		{
			Ametys.explorer.ExplorerNodeDAO.getExplorerNodes(parameters.ids, Ext.bind(this._createTargets, this, [callback, parameters], true));
		}
		else if (parameters.nodes)
		{
			this._createTargets(parameters.nodes, callback, parameters);
		}
	},

	/**
	 * Create the content targets
	 * @param {Ametys.explorer.ExplorerNode[]} nodes The nodes
	 * @param {Function} callback The callback function called when the targets are created. Parameters are
	 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
	 * @param {Object} parameters The initial parameters of the #createTargets method
	 * @private
	 */
	_createTargets: function (nodes, callback, parameters)
	{
		delete parameters['ids'];
		delete parameters['nodes'];
		
		var targets = [];
		
		for (var i=0; i < nodes.length; i++)
		{
			targets.push(Ext.create('Ametys.message.MessageTarget', {
				id: this.getId(),
				parameters: nodes[i].getProperties(parameters)
			}));	
		}
			
		callback(targets);
	}
});

Ext.define('Ametys.message.ExplorerNodeMessageTarget', {
	override: 'Ametys.message.MessageTarget',
	
	statics: 
	{
		/**
		 * @member Ametys.message.MessageTarget
		 * @readonly
		 * @property {String} EXPLORER_COLLECTION The target type is an explorer collection. 
		 */
		EXPLORER_COLLECTION: "explorer-collection",
		
		/**
		 * @member Ametys.message.MessageTarget
		 * @readonly
		 * @property {String} RESOURCE The target type is a resource. 
		 */
		RESOURCE: "resource",
		
		/**
		 * @member Ametys.message.MessageTarget
		 * @readonly
		 * @property {String} EXPLORER_THREAD The target type is an explorer thread. 
		 */
		EXPLORER_THREAD: "explorer-thread"
	}
});

