/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ext.define('Ametys.plugins.explorer.message.ExplorerNodeTargetToContextConvertor', {
    extend: 'Ametys.plugins.coreui.rights.AbstractTargetToContextConvertor',
    
    isSupportedTarget: function(target)
    {
        return target != null
        && (target.getId() == Ametys.message.MessageTarget.RESOURCE
            || target.getId() == Ametys.message.MessageTarget.EXPLORER_COLLECTION);
    },
    
    convert: function(target)
    {
        return target.getParameters().id;
    },
    
    getContextInfo:function(target)
    {
        if (target.getId() == Ametys.message.MessageTarget.RESOURCE)
        {
            return {label: target.getParameters().name, type: '{{i18n PLUGINS_EXPLORER_EXPLORER_NODE_TARGET_CONVERTOR_RESOURCE_TYPE_LABEL}}'};
        }
        else if (this._isRootNode(target))
        {
            return this.getRootNodeContextInfo(target);
        }
        else
        {
            return {label: target.getParameters().name, type: "{{i18n PLUGINS_EXPLORER_EXPLORER_NODE_TARGET_CONVERTOR_EXPLORER_COLLECTION_TYPE_LABEL}}"};
        }
    },
    
    _isRootNode: function(target)
    {
        return target.getParameters().id == target.getParameters().rootId;
    },
    
    getRootNodeContextInfo(target)
    {
        return {label: "{{i18n PLUGINS_EXPLORER_RIGHT_ASSIGNMENT_CONTEXT_RESOURCES_HINT_ALL}}"}
    }
});

