<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:dc="http://purl.org/dc/elements/1.1/">
	
    <xsl:template match="/">
        <xsl:apply-templates select="//dublin-core-metadata"/>
    </xsl:template>
    
    <xsl:template match="dublin-core-metadata">
        <rdf:RDF>
            <rdf:Description rdf:about="http://dublincore.org/documents/dcq-html/">
                <xsl:apply-templates select="node()[normalize-space(.) != '']"/>
            </rdf:Description>
        </rdf:RDF>
    </xsl:template>
    
    <xsl:template match="*">
        <xsl:element name="dc:{local-name()}">
            <xsl:value-of select="."/>
        </xsl:element>
    </xsl:template>
    
</xsl:stylesheet>
