/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * {@link AmetysObject} composing the resources tree of the resources explorer.
 */
public interface ExplorerNode extends AmetysObject
{
    /**
     * Returns the icon css class for this Node.
     * @return the icon css class for this Node
     * for rendering in the tree.
     */
    public String getIconCls();
    
    /**
     * Returns the application id corresponding to this Node.
     * @return the application id corresponding to this Node.
     */
    public String getApplicationId();
    
    /**
     * Returns the path of this explorer node in the explorer hierarchy (which is a subset of the whole repository).<br>
     * If this collection is the root explorer node, "" is returned.
     * @return the path of this node in its hierarchy.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getExplorerPath();
    
    /**
     * Returns true if this explorer node contains child explorer nodes.
     * @return true if this explorer node contains child explorer nodes.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public boolean hasChildExplorerNodes() throws AmetysRepositoryException;
    
    /**
     * Get the description of the application
     * @return the description
     */
    public String getDescription();
}
