/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer;

/**
 * Constants for observers.
 */
public interface ObservationConstants
{
    // ------------------------- //
    // Resources and collections //
    // ------------------------- //
    
    /** Event id when a resource is created. */
    public static final String EVENT_RESOURCE_CREATED = "resource.created";
    
    /** Event id when a resource is modified. */
    public static final String EVENT_RESOURCE_UPDATED = "resource.updated";
    
    /** Event id when a resource is renamed. */
    public static final String EVENT_RESOURCE_RENAMED = "resource.renamed";
    
    /** Event id when a resource is deleted. */
    public static final String EVENT_RESOURCE_DELETED = "resource.deleted";
    
    /** Event id when a resource is moved. */
    public static final String EVENT_RESOURCE_MOVED = "resource.moved";
    
    /** Event id when a collection is created. */
    public static final String EVENT_COLLECTION_CREATED = "collection.created";
    
    /** Event id when a collection is renamed. */
    public static final String EVENT_COLLECTION_RENAMED = "collection.renamed";
    
    /** Event id when a collection is deleting. */
    public static final String EVENT_COLLECTION_DELETING = "collection.deleting";
    
    /** Event id when a collection is deleted. */
    public static final String EVENT_COLLECTION_DELETED = "collection.deleted";
    
    /** Event id when a collection is moved. */
    public static final String EVENT_COLLECTION_MOVED = "collection.moved";
    
    /** Event id when a collection is copied. */
    public static final String EVENT_COLLECTION_COPIED = "collection.copied";
    
    /** Event id when a CMIS collection is updated. */
    public static final String EVENT_CMIS_COLLECTION_UPDATED = "cmis.collection.updated";
    
    // ----------------//
    // Event arguments //
    // ----------------//
    
    /** Argument name for processed object's id */
    public static final String ARGS_ID = "object.id";
    
    /** Argument name for processed object's name */
    public static final String ARGS_NAME = "object.name";
    
    /** Argument name for processed object's path */
    public static final String ARGS_PATH = "object.path";
    
    /** Argument name for processed object's parent id */
    public static final String ARGS_PARENT_ID = "object.parent";
    
    /** Argument name for processed object's parent path */
    public static final String ARGS_PARENT_PATH = "object.parent.path";
    
    /** Argument name for processed resources */
    public static final String ARGS_RESOURCES = "resources";
    
    /** Argument name for processed resource path */
    public static final String ARGS_RESOURCE_PATH = "resource.path";
    
    /** Argument name for processed explorer path */
    public static final String ARGS_EXPLORER_PATH = "explorer.path";
}
