/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.clientsideelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * This element creates a button which stores id of images contained in selection
 */
public class ImagesContainerClientSideElement extends StaticClientSideElement
{
    /** Ametys Repository */
    protected AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    /**
     * Get the list of direct child images of a ResourceCollection 
     * @param id The id of the ResourceCollection or a child Resource
     * @return The list of images id
     */
    // FIXME no read access is checked as resource tree does not filter resources on read access
    @Callable (rights = Callable.NO_CHECK_REQUIRED) 
    public Map<String, Object> getImages (String id)
    {
        Map<String, Object> results = new HashMap<>();
        
        AmetysObject ao = _resolver.resolveById(id);
        
        List<String> images = new ArrayList<>();
        
        ResourceCollection collection = null;
        if (ao instanceof ResourceCollection)
        {
            collection = (ResourceCollection) ao;
        }
        else if (ao instanceof Resource)
        {
            collection = ao.getParent();
        }
        
        if (collection != null)
        {
            for (AmetysObject child : collection.getChildren())
            {
                if (child instanceof Resource)
                {
                    Resource resource = (Resource) child;
                    if (_isImage(resource))
                    {
                        images.add (resource.getId());
                    }
                }
            }
        }
        
        results.put("images", images);
        return results;
    }
    
    private boolean _isImage (Resource resource)
    {
        String filename = resource.getName().toLowerCase();
        return filename.endsWith(".jpeg") || filename.endsWith(".jpg") || filename.endsWith(".gif") || filename.endsWith(".png");
    }

}
