/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.dublincore;

import java.io.IOException;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;

/**
 * Generates Dublin Core metadata.
 */
public class DublinCoreMetadataGenerator extends ServiceableGenerator
{
    private ExplorerResourcesDAO _resourceDAO;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _resourceDAO = (ExplorerResourcesDAO) serviceManager.lookup(ExplorerResourcesDAO.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String id = parameters.getParameter("id", request.getParameter("id"));
        
        Map<String, Object> dcMetadata = _resourceDAO.getDCMetadata(id);
        
        contentHandler.startDocument();
        
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", id);
        
        XMLUtils.startElement(contentHandler, "object", atts);
        
        XMLUtils.startElement(contentHandler, "dublin-core-metadata");
        for (String metadataName : dcMetadata.keySet())
        {
            _saxIfNotNull(metadataName, dcMetadata.get(metadataName));
        }
        XMLUtils.endElement(contentHandler, "dublin-core-metadata");
        
        XMLUtils.endElement(contentHandler, "object");
        
        contentHandler.endDocument();
        
    }
    
    
    /**
     * SAX string Dublin Core metadata.
     * @param name the metadata name.
     * @param value the metadata value.
     * @throws SAXException if an error occurs while SAXing.
     */
    protected void _saxIfNotNull(String name, Object value) throws SAXException
    {
        if (value != null)
        {
            if (value instanceof String[])
            {
                for (String val : (String[]) value)
                {
                    XMLUtils.createElement(contentHandler, name, val);
                }
            }
            else if (value instanceof String)
            {
                XMLUtils.createElement(contentHandler, name, (String) value);
            }
            else
            {
                XMLUtils.createElement(contentHandler, name, String.valueOf(value));
            }
            
        }
    }
}
