/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.dublincore;

import java.io.IOException;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * SAX the enumerated values for a DublinCore metadata
 */
public class EnumeratedValuesGenerator extends ServiceableGenerator
{
    private DublinCoreMetadataProvider _dcProvider;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _dcProvider = (DublinCoreMetadataProvider) smanager.lookup(DublinCoreMetadataProvider.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        String metadataName = parameters.getParameter("metadataName", null);

        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "enumeration");
        
        if (metadataName != null && _dcProvider.isEnumerated(metadataName))
        {
            Map<String, I18nizableText> entries = _dcProvider.getEntries(metadataName);
            
            for (String value : entries.keySet())
            {
                XMLUtils.startElement(contentHandler, "entry");
                XMLUtils.createElement(contentHandler, "value", value);
                I18nizableText label = entries.get(value);
                if (label != null)
                {
                    label.toSAX(contentHandler, "label");
                }
                else
                {
                    XMLUtils.createElement(contentHandler, "label", value);
                }
                XMLUtils.endElement(contentHandler, "entry");
            }
        }
        XMLUtils.endElement(contentHandler, "enumeration");
        contentHandler.endDocument();
    }

}
