/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources;

import java.io.InputStream;
import java.util.Date;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.dublincore.ModifiableDublinCoreAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObject;

/**
 * Interface representing a modifiable resource file of a resources explorer node.
 */
public interface ModifiableResource extends Resource, ModifiableDublinCoreAwareAmetysObject, RemovableAmetysObject, LockableAmetysObject, TaggableAmetysObject
{
    /**
     * Set binary data.
     * @param stream The {@link InputStream}.
     * @param mimeType The file mimetype.
     * @param lastModified The date of last modification.
     * @param author The author of last modification.
     */
    public void setData(InputStream stream, String mimeType, Date lastModified, UserIdentity author);
    
    /**
     * Set the creator of the resource
     * @param creator The author
     */
    public void setCreator (UserIdentity creator);
    
    /**
     * Set the last contributor of the resource
     * @param lastContributor The last contributor
     */
    public void setLastContributor(UserIdentity lastContributor);
    /**
     * Set the last modified date if this resource.
     * @param lastModified the last modified date.
     */
    public void setLastModified(Date lastModified);
    /**
     * Set the creation date if this resource.
     * @param creationDate the creation date.
     */
    public void setCreationDate(Date creationDate);
    
    /**
     * Set this resource's keywords.
     * @param keywords the comma-separated keywords.
     */
    public void setKeywords(String keywords);
    
    /**
     * Set this resource's keywords.
     * @param keywords the keywords.
     */
    public void setKeywords(String[] keywords);
    
    /**
     * Set this resource mime type.
     * @param mimeType the mime type.
     */
    public void setMimeType(String mimeType);
}
