/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources;

import java.io.InputStream;
import java.util.Date;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.dublincore.DublinCoreAwareAmetysObject;

/**
 * Common interface for a resource file of a resources explorer node.
 */
public interface Resource extends DublinCoreAwareAmetysObject
{
    /**
     * Returns the data stream.
     * @return the data stream.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public InputStream getInputStream () throws AmetysRepositoryException;
    
    /**
     * Retrieves the creation date.
     * @return the creation date.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public Date getCreationDate() throws AmetysRepositoryException;
    
    /**
     * Returns the last modification date.
     * @return the last modification date.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public Date getLastModified () throws AmetysRepositoryException;
    
    /**
     * Returns the length of the data stream.
     * @return the length of the data stream.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public long getLength() throws AmetysRepositoryException;
    
    /**
     * Returns the last contributor of this resource.
     * @return the last contributor of this resource.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public UserIdentity getCreator() throws AmetysRepositoryException;
    
    /**
     * Retrieves the login of the last contributor.
     * @return the login of the last contributor.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public UserIdentity getLastContributor() throws AmetysRepositoryException;
    
    /**
     * Returns the keywords of this resource, as a String array.
     * @return the keywords of this resource.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String[] getKeywords() throws AmetysRepositoryException;
    
    /**
     * Returns the keywords of this resource, as a comme-separated String.
     * @return the keywords of this resource.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getKeywordsAsString() throws AmetysRepositoryException;
    
    /**
     * Returns the data mime-type.
     * @return the data mime-type.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getMimeType()  throws AmetysRepositoryException;
    
    /**
     * Returns the path of this resource in its hierarchy (which is a subset of the whole repository).
     * @return the path of this resource in its hierarchy.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public String getResourcePath() throws AmetysRepositoryException;
}
