/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.explorer.resources;

import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.TraversableAmetysObject;

/**
 * Common interface for modifiable resource collection
 */
public interface ResourceCollection extends TraversableAmetysObject, ExplorerNode
{
    /**
     * Returns the path of this resource collection in its hierarchy (which is a subset of the whole repository).<br>
     * If this collection is the root collection, "" is returned.
     * @return the path of this collection in its hierarchy.
     * @throws AmetysRepositoryException if an error occurs.
     * @deprecated Use the getExplorerPath method
     */
    @Deprecated
    public String getResourcePath() throws AmetysRepositoryException;
    
    /**
     * Returns true if this explorer node contains resources.
     * @return true if this explorer node contains resources.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public boolean hasChildResources() throws AmetysRepositoryException;
    
}
