/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources;

import java.util.Map;

import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.repository.trash.AbstractStaticTrashElementType;
import org.ametys.plugins.repository.trash.TrashElement;
import org.ametys.plugins.repository.trash.TrashableAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Trash element type for {@link JCRResourcesCollection}
 */
public class ResourceCollectionTrashElementType extends AbstractStaticTrashElementType
{
    public boolean supports(TrashableAmetysObject element)
    {
        return element instanceof JCRResourcesCollection;
    }

    public Map<String, String> getIcon(TrashElement element)
    {
        return Map.of("iconGlyph", "ametysicon-folder249");
    }
    
    public Map<String, Object> getNotificationOpenToolAction(TrashableAmetysObject restoredObject)
    {
        return Map.of();
    }
    
    public I18nizableText getRestorationDescription(TrashableAmetysObject object)
    {
        if (object instanceof JCRResourcesCollection collection)
        {
            return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_RESOURCE_COLLECTION_RESTORED_DESCRIPTION",
                    Map.of("name", new I18nizableText(collection.getName()))
                );
        }
        throw new IllegalStateException(object.toString() + " is not supported");
    }
    
    public void additionnalRestoreAction(TrashableAmetysObject restoredObject)
    {
        // Nothing to do
    }
}
