/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;

/**
 * Helper class that provides utility methods to work with resources.
 */
public final class ResourceHelper
{
    
    private ResourceHelper()
    {
        // Hide the default constructor.
    }
    
    /**
     * Get the resource root of a resource.
     * @param resource The resource.
     * @return The resource root.
     */
    public static TraversableAmetysObject getResourceRoot(Resource resource)
    {
        return _getResourceRoot(resource);
    }
    
    /**
     * Get the resource root of a resource collection.
     * @param collection The resource collection.
     * @return The resource root.
     */
    public static TraversableAmetysObject getResourceRoot(ResourceCollection collection)
    {
        return _getResourceRoot(collection);
    }
    
    /**
     * Get the resource root of an ametys object.
     * @param object The object.
     * @return The resource root of the ametys object.
     */
    private static TraversableAmetysObject _getResourceRoot(AmetysObject object)
    {
        AmetysObject current = object;
        TraversableAmetysObject parent = object.getParent();
        
        while (parent != null && parent instanceof ResourceCollection)
        {
            current = parent;
            parent = current.getParent();
        }
        
        return current instanceof TraversableAmetysObject ? (TraversableAmetysObject) current : null;
    }
    
}
