/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources.actions;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.acting.HttpHeaderAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * This action adds HTTP headers to the response for a ZIP archive
 */
public class SetHttpHeaderForArchive extends HttpHeaderAction implements Serviceable
{
    private AmetysObjectResolver _resolver;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Map result = super.act(redirector, resolver, objectModel, source, parameters);
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        String name = request.getParameter("name");
        if (StringUtils.isNotEmpty(name))
        {
            name = URIUtils.decode(name);
        }
        else if (request.getParameter("file") != null)
        {
            // Get the name of first file
            AmetysObject ao = _resolver.resolveById(request.getParameter("file"));
            name = ao.getName();
            if (ao instanceof Resource)
            {
                name = name.substring(0, name.lastIndexOf("."));
            }
        }
        else
        {
            // Use the folder name
            String id = request.getParameter("id");
            ResourceCollection collection = _resolver.resolveById(id);
            name = collection.getName();
        }
        
        name = name.replaceAll("\\\\", "\\\\\\\\");
        name = name.replaceAll("\\\"", "\\\\\\\"");
        
        Response response = ObjectModelHelper.getResponse(objectModel);
        
        response.setHeader("Content-Disposition", "attachment; filename=\"" + name + ".zip\"");
        
        return result;
    }
}
