/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.explorer.resources.dom;

import java.util.Iterator;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.ametys.core.util.dom.AbstractWrappingAmetysElement;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.dom.AmetysObjectElement;

/**
 * DOM {@link Element} wrapping a {@link Resource} or a {@link ResourceCollection}.
 * @param <A> the actual type of the wrapped object.
 */
public abstract class AbstractResourceElement<A extends AmetysObject> extends AmetysObjectElement<A>
{
    /**
     * Constructor.
     * @param object the wrapped object.
     */
    public AbstractResourceElement(A object)
    {
        super(object);
    }
    
    /**
     * Constructor.
     * @param object the wrapped object.
     * @param parent the parent collection.
     */
    public AbstractResourceElement(A object, ResourceCollectionElement parent)
    {
        super(object, parent);
    }
    
    @Override
    public Node getNextSibling()
    {
        if (_parent == null)
        {
            return null;
        }
        
        ResourceCollection parent = (ResourceCollection) ((AbstractWrappingAmetysElement) _parent).getWrappedObject();
        
        AmetysObjectIterable<AmetysObject> children = parent.getChildren();
        
        boolean isNext = false;
        AmetysObject nextSibling = null;
        Iterator<AmetysObject> it = children.iterator();
        
        while (nextSibling == null && it.hasNext())
        {
            AmetysObject child = it.next();
            
            if (isNext && (child instanceof Resource || child instanceof ResourceCollection))
            {
                nextSibling = child;
            }
            else if (_object.getId().equals(child.getId()))
            {
                isNext = true;
            }
        }
        
        if (nextSibling == null)
        {
            return null;
        }
        else if (nextSibling instanceof Resource)
        {
            return new ResourceElement((Resource) nextSibling, (ResourceCollectionElement) _parent);
        }
        else
        {
            return new ResourceCollectionElement((ResourceCollection) nextSibling, (ResourceCollectionElement) _parent);
        }
    }
}
