/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.explorer.resources.dom;

import java.util.Iterator;
import java.util.Map;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;

/**
 * DOM {@link Element} wrapping a {@link ResourceCollection}.
 */
public class ResourceCollectionElement extends AbstractResourceElement<ResourceCollection>
{
    /**
     * Constructor.
     * @param collection the wrapped object.
     */
    public ResourceCollectionElement(ResourceCollection collection)
    {
        super(collection);
    }
    
    /**
     * Constructor.
     * @param collection the wrapped object.
     * @param parent the parent collection.
     */
    public ResourceCollectionElement(ResourceCollection collection, ResourceCollectionElement parent)
    {
        super(collection, parent);
    }
    
    @Override
    public String getTagName()
    {
        return "collection";
    }
    
    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes()
    {
        Map<String, AmetysAttribute> atts = super._lookupAttributes();
        atts.put("name", new AmetysAttribute("name", "name", null, _object.getName(), this));
        atts.put("id", new AmetysAttribute("id", "id", null, _object.getId(), this));
        
        return atts;
    }
    
    @Override
    public Node getFirstChild()
    {
        AmetysObjectIterable<AmetysObject> children = _object.getChildren();
        Iterator<AmetysObject> it = children.iterator();
        
        if (!it.hasNext())
        {
            return null;
        }
        
        AmetysObject object = it.next();
        
        if (object instanceof ResourceCollection)
        {
            return new ResourceCollectionElement((ResourceCollection) object, this);
        }
        else if (object instanceof Resource)
        {
            return new ResourceElement((Resource) object, this);
        }
        
        return null;
    }
}
