/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources.generators;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObject;

/**
 * SAX events for {@link Resource}s and/or  {@link ExplorerNode}s
 */
public class ExplorerEntitiesGenerator extends ResourcesExplorerGenerator
{
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        @SuppressWarnings("unchecked")
        Map<String, Object> jsParameters = (Map<String, Object>) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        @SuppressWarnings("unchecked")
        List<String> ids = (List<String>) jsParameters.get("ids");
        
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "Nodes");
        
        for (String id : ids)
        {
            AmetysObject object = _resolver.resolveById(id);
            
            if (object instanceof ExplorerNode)
            {
                saxCollection((ExplorerNode) object, true);
            }
            else if (object instanceof Resource)
            {
                saxResource((Resource) object);
            }
        }
        
        XMLUtils.endElement(contentHandler, "Nodes");
        contentHandler.endDocument();
    }
}
