/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources.generators;

import java.io.IOException;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * SAX the users rights on resource
 */

public class UserRightsGenerator extends ServiceableGenerator
{
    private AmetysObjectResolver _resolver;

    private RightManager _rightManager;

    private CurrentUserProvider _userProvider;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);

        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
        _rightManager = (RightManager) serviceManager.lookup(RightManager.ROLE);
        _userProvider = (CurrentUserProvider) serviceManager.lookup(CurrentUserProvider.ROLE);
    }
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String id = request.getParameter("explorerNodeId");
        
        ExplorerNode node = (ExplorerNode) _resolver.resolveById(id);
        
        UserIdentity user = _userProvider.getUser();
        Set<String> rights = _rightManager.getUserRights(user, node);

        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "user-rights");

        for (String rightID : rights)
        {
            AttributesImpl rightAttr = new AttributesImpl();
            rightAttr.addCDATAAttribute("id", rightID);
            XMLUtils.createElement(contentHandler, "right", rightAttr);
        }
        
        XMLUtils.endElement(contentHandler, "user-rights");
        contentHandler.endDocument();

    }

}
