/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources.jcr;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.jcr.DefaultLockableAmetysObjectFactory;
import org.ametys.plugins.repository.trash.TrashElementDAO;

/**
 * {@link AmetysObjectFactory} for handling {@link JCRResource}s.
 */
public class JCRResourceFactory extends DefaultLockableAmetysObjectFactory
{
    /** JCR nodetype for resources collection */
    public static final String RESOURCES_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":resource";
    private TrashElementDAO _trashElementDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        if (manager.hasService(TrashElementDAO.ROLE))
        {
            _trashElementDAO = (TrashElementDAO) _manager.lookup(TrashElementDAO.ROLE);
        }
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public JCRResource getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new JCRResource(node, parentPath, this);
    }
    
    TrashElementDAO _getTrashElementDAO()
    {
        if (_trashElementDAO != null)
        {
            return _trashElementDAO;
        }
        else
        {
            throw new UnsupportedOperationException("No component avaible for role " + TrashElementDAO.ROLE);
        }
    }
    
    AmetysObjectResolver _getResolver()
    {
        return _resolver;
    }
}
