/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources.matchers;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;

/**
 * This matcher matches URI with protocol inside
 * Can be /view/protocol://resourceid/file/filename.ext
 * or /download/...
 */
public class ResourceMatcher implements Matcher
{
    private static final Pattern __PATTERN = Pattern.compile("(download|view)/(.*)/file/[^/]*");
    
    @Override
    public Map match(String pattern, Map objectModel, Parameters parameters) throws PatternException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String sitemapURI = request.getRequestURI().substring((request.getContextPath() + "/" + request.getSitemapURIPrefix()).length());
        
        java.util.regex.Matcher m = __PATTERN.matcher(sitemapURI);
        if (m.matches())
        {
            Map<String, String> results = new HashMap<>();
            results.put("download", Boolean.toString("download".equals(m.group(1))));
            results.put("id", m.group(2));
            return results;
        }
        else
        {
            return null;
        }
    }

}
