/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.resources.metadata.populate;

import java.util.Set;

import org.apache.tika.metadata.Metadata;

import org.ametys.plugins.explorer.resources.ModifiableResource;

/**
 * Populate resource properties from tika {@link Metadata}.
 */
public interface ResourceMetadataPopulator
{
    
    /**
     * Returns the MIME types handled by this {@link ResourceMetadataPopulator}.
     * @return the MIME types handled by this {@link ResourceMetadataPopulator}.
     */
    public Set<String> getTypes();
    
    /**
     * Populate the resource's properties from the provided Metadata.
     * @param resource the resource to populate.
     * @param metadata the parsed resources Metadata.
     */
    public void populate(ModifiableResource resource, Metadata metadata);
    
}
