/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.rights;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.right.AbstractStaticRightAssignmentContext;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * {@link RightAssignmentContext} for assign rights to a {@link Resource} or a {@link ResourceCollection}
 */
public class ResourceRightAssignmentContext extends AbstractStaticRightAssignmentContext
{
    /** The id if this right context */
    public static final String ID = "right.assignment.context.resource";
    
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;
    /** The resources DAO */
    protected ExplorerResourcesDAO _resourcesDAO;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
        _resourcesDAO = (ExplorerResourcesDAO) smanager.lookup(ExplorerResourcesDAO.ROLE);
    }
    
    @Override
    public Object convertJSContext(Object context)
    {
        if (context instanceof String)
        {
            return _resolver.resolveById((String) context);
        }
        return null;
    }
    
    @Override
    public String getContextIdentifier(Object context)
    {
        if (context instanceof ExplorerNode)
        {
            return ((ExplorerNode) context).getId();
        }
        return null;
    }
    
    @Override
    public Set<Object> getParentContexts(Object context)
    {
        if (context instanceof ExplorerNode)
        {
            AmetysObject parent = ((ExplorerNode) context).getParent();
            if (parent instanceof ExplorerNode)
            {
                return Collections.singleton(parent);
            }
        }
        return null;
    }
    
    @Override
    public List<Object> getRootContexts(Map<String, Object> contextParameters)
    {
        List<Object> rootContexts = new ArrayList<>();
        
        if (matchWorkspace(contextParameters))
        {
            rootContexts.addAll(_resourcesDAO.getResourcesRootNodes());
        }
        
        return rootContexts;
    }
}
