/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.workflow;

import java.util.Map;

import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;

import com.opensymphony.workflow.WorkflowException;

/**
 * Abstract class for easily retrieving environment components
 * in a condition or a function and especially a resource.
 */
public abstract class AbstractExplorerNodeWorkflowComponent extends AbstractWorkflowComponent
{
    /** Constant for storing the content into the transient variables map. */
    public static final String EXPLORERNODE_KEY = ExplorerNode.class.getName();

    /**
     * Retrieve the resource associated with the workflow.
     * @param transientVars the parameters from the call.
     * @return the resource.
     * @throws WorkflowException if the resource is not found.
     */
    protected ExplorerNode getExplorerNode(Map transientVars) throws WorkflowException
    {
        ExplorerNode explorerNode = (ExplorerNode) transientVars.get(AbstractExplorerNodeWorkflowComponent.EXPLORERNODE_KEY);
        
        if (explorerNode == null)
        {
            throw new WorkflowException("Unable to retrieve explorer node");
        }
        
        // Found in transient variables map
        return explorerNode;
    }

}
