/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.explorer.workflow;

import java.util.List;
import java.util.Map;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workflow.component.CheckRightsCondition;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * This workflow function check rights on explorer node
 */
public class ExplorerNodeCheckRightsCondition extends CheckRightsCondition
{
    @Override
    protected Object _computeContext(Map transientVars, Map args, UserIdentity user, String right) throws WorkflowException
    {
        try
        {
            return getExplorerNode(transientVars);
        }
        catch (AmetysRepositoryException e)
        {
            throw new WorkflowException("Unable to retrieve content name", e);
        }
    }

    /**
     * Retrieve the resource associated with the workflow.
     * @param transientVars the parameters from the call.
     * @return the resource.
     * @throws WorkflowException if the resource is not found.
     */
    protected ExplorerNode getExplorerNode(Map transientVars) throws WorkflowException
    {
        ExplorerNode explorerNode = (ExplorerNode) transientVars.get(AbstractExplorerNodeWorkflowComponent.EXPLORERNODE_KEY);
        
        if (explorerNode == null)
        {
            throw new WorkflowException("Unable to retrieve explorer node");
        }
        
        // Found in transient variables map
        return explorerNode;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_EXPLORER_NODE_CHECK_RIGHTS_CONDITION_LABEL");
    }
    
    @Override
    protected I18nizableText _getMultipleConditionsDescriptionKey(List<String> parameters)
    {
        return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_EXPLORER_NODE_CHECK_RIGHTS_MULTIPLES_CONDITION_DESCRIPTION", parameters);
    }
    
    @Override
    protected I18nizableText _getSingleConditionDescriptionKey(List<String> parameters)
    {
        return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_EXPLORER_NODE_CHECK_RIGHTS_CONDITION_DESCRIPTION", parameters);
    }
}
