/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repositoryapp.jcr;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.core.NodeImpl;
import org.slf4j.Logger;

public final class VersionHistoryHelper {
    private VersionHistoryHelper() {
    }

    public static RemoveHistoryResult removeUnusedHistory(Map<String, Session> sessions, VersionHistory versionHistory, Logger logger) throws RepositoryException {
        String versionableIdentifier = versionHistory.getVersionableIdentifier();
        for (Map.Entry<String, Session> entry : sessions.entrySet()) {
            try {
                entry.getValue().getNodeByIdentifier(versionableIdentifier);
                return RemoveHistoryResult.REFERENCED;
            }
            catch (RepositoryException repositoryException) {
            }
        }
        VersionIterator it = versionHistory.getAllVersions();
        int childNodesSize = 0;
        while (it.hasNext()) {
            Version version = it.nextVersion();
            if ("jcr:rootVersion".equals(version.getName())) continue;
            ++childNodesSize;
            try {
                versionHistory.removeVersion(version.getName());
            }
            catch (RepositoryException e) {
                logger.error("Error with version " + version.getName() + " of " + versionHistory.getIdentifier() + "... " + String.valueOf((Object)e));
                return RemoveHistoryResult.ERROR;
            }
        }
        if (childNodesSize == 0) {
            VersionHistoryHelper._removeEmptyHistory(versionHistory, sessions.get("default"));
            try {
                sessions.get("default").getNodeByIdentifier(versionHistory.getIdentifier());
                logger.debug("Empty history node is " + versionHistory.getIdentifier());
                return RemoveHistoryResult.UNFIXABLE;
            }
            catch (RepositoryException e) {
                return RemoveHistoryResult.FIXED;
            }
        }
        return RemoveHistoryResult.REMOVED;
    }

    private static void _removeEmptyHistory(VersionHistory vh, Session session) throws RepositoryException {
        Node node = ((NodeImpl)session.getNode("/ametys:root")).addNodeWithUuid("historyrepair", "nt:unstructured", vh.getProperty("jcr:versionableUuid").getString());
        node.addMixin("mix:versionable");
        session.save();
        session.getWorkspace().getVersionManager().checkin(node.getPath());
        session.getWorkspace().getVersionManager().checkout(node.getPath());
        session.removeItem("/ametys:root/historyrepair");
        session.save();
        vh.removeVersion("1.0");
    }

    public static enum RemoveHistoryResult {
        REMOVED,
        REFERENCED,
        ERROR,
        FIXED,
        UNFIXABLE;

    }
}

