/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;

public final class NodeGroupHelper {
    public static final int MAX_CHILDREN_PER_NODE = 100;

    private NodeGroupHelper() {
    }

    public static String getPathWithGroups(Node node) throws RepositoryException {
        StringBuffer fullPath = new StringBuffer();
        int depth = node.getDepth();
        for (int i = 0; i < depth; ++i) {
            Node ancestor = (Node)node.getAncestor(i);
            Node ancestorChild = (Node)node.getAncestor(i + 1);
            if (!ancestor.getName().equals("")) {
                fullPath.append('/').append(ancestor.getName());
                int index = ancestor.getIndex();
                if (index > 1) {
                    fullPath.append('[').append(index).append(']');
                }
            }
            fullPath.append(NodeGroupHelper.getGroupPaths(ancestorChild, 100));
        }
        fullPath.append('/').append(node.getName());
        int index = node.getIndex();
        if (index > 1) {
            fullPath.append('[').append(index).append(']');
        }
        return fullPath.toString();
    }

    private static String getGroupPaths(Node node, int maxNodesPerGroup) throws RepositoryException {
        StringBuilder nodePath = new StringBuilder();
        NodeIterator children = node.getParent().getNodes();
        long childCount = children.getSize();
        if (childCount > (long)maxNodesPerGroup) {
            int level = (int)Math.ceil(Math.log(childCount) / Math.log(maxNodesPerGroup)) - 1;
            int position = 0;
            boolean found = false;
            while (children.hasNext() && !found) {
                if (children.nextNode().isSame((Item)node)) {
                    found = true;
                    continue;
                }
                ++position;
            }
            for (int j = level; j > 0; --j) {
                int currentGroupCount = (int)Math.pow(maxNodesPerGroup, j);
                int groupIndex = position / currentGroupCount;
                int startPos = groupIndex * currentGroupCount + 1;
                int endPos = Math.min(startPos + currentGroupCount - 1, (int)childCount);
                nodePath.append('/').append(startPos).append("...").append(endPos);
            }
        }
        return nodePath.toString();
    }
}

