/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;

public final class NodeHelper {
    private NodeHelper() {
    }

    public static void rename(Node node, String newName) throws RepositoryException {
        Node parentNode = node.getParent();
        boolean order = parentNode.getPrimaryNodeType().hasOrderableChildNodes();
        Node nextSibling = null;
        if (order) {
            Node sibling;
            NodeIterator siblings = parentNode.getNodes();
            boolean iterate = true;
            while (siblings.hasNext() && iterate) {
                sibling = siblings.nextNode();
                iterate = !sibling.getName().equals(node.getName());
            }
            while (siblings.hasNext() && nextSibling == null) {
                sibling = siblings.nextNode();
                String path = sibling.getPath();
                if (!node.getSession().itemExists(path)) continue;
                nextSibling = sibling;
            }
        }
        node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + newName);
        if (order) {
            if (nextSibling != null) {
                parentNode.orderBefore(newName, nextSibling.getName());
            } else {
                parentNode.orderBefore(newName, null);
            }
        }
    }

    public static Node getChildAt(Node node, int index) throws NoSuchElementException, RepositoryException {
        if (index < 0) {
            throw new NoSuchElementException("Child node index cannot be negative (" + index + ")");
        }
        NodeIterator nodes = node.getNodes();
        nodes.skip((long)index);
        return nodes.nextNode();
    }
}

