/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class NodeStateTracker
extends AbstractLogEnabled
implements Component,
Initializable {
    public static final String ROLE = NodeStateTracker.class.getName();
    protected Map<String, Set<String>> _newNodes;

    public void initialize() throws Exception {
        this._newNodes = new HashMap<String, Set<String>>();
    }

    public Set<String> getNewNodes(String workspaceName) {
        HashSet<String> nodes = new HashSet<String>();
        if (this._newNodes.containsKey(workspaceName)) {
            nodes.addAll((Collection<String>)this._newNodes.get(workspaceName));
        }
        return nodes;
    }

    public void nodeAdded(String workspaceName, String path) throws RepositoryException {
        Set<Object> newNodes = null;
        if (this._newNodes.containsKey(workspaceName)) {
            newNodes = this._newNodes.get(workspaceName);
        } else {
            newNodes = new HashSet();
            this._newNodes.put(workspaceName, newNodes);
        }
        newNodes.add(path);
    }

    public void nodeRemoved(String workspaceName, String path) throws RepositoryException {
        Set<Object> newNodes = null;
        if (this._newNodes.containsKey(workspaceName)) {
            newNodes = this._newNodes.get(workspaceName);
        } else {
            newNodes = new HashSet();
            this._newNodes.put(workspaceName, newNodes);
        }
        newNodes.remove(path);
    }

    public void clear(String workspaceName) {
        if (this._newNodes.containsKey(workspaceName)) {
            this._newNodes.get(workspaceName).clear();
        }
    }
}

