/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.io.IOException;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.ametys.workspaces.repository.jcr.AbstractRepositoryGenerator;
import org.ametys.workspaces.repository.jcr.NodeGroupHelper;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class QueryResultGenerator
extends AbstractRepositoryGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String workspaceName = this.parameters.getParameter("workspace", "default");
        this.contentHandler.startDocument();
        if (StringUtils.isNotBlank((CharSequence)workspaceName)) {
            this._getRepository(request, workspaceName);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Trying to generate results for a XPath query");
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"resultList");
            String query = this.parameters.getParameter("query", "");
            String language = this.parameters.getParameter("language", "xpath");
            if (StringUtils.isNotBlank((CharSequence)query)) {
                this._populateQueryResult(this._session, query, language);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"resultList");
        }
        this.contentHandler.endDocument();
    }

    private void _populateQueryResult(Session session, String query, String language) throws SAXException {
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            QueryResult queryResult = queryManager.createQuery(query, language).execute();
            String[] selectorNames = queryResult.getSelectorNames();
            String selector = selectorNames.length > 0 ? selectorNames[0] : null;
            RowIterator rows = queryResult.getRows();
            while (rows.hasNext()) {
                Row row = rows.nextRow();
                Node node = selector == null ? row.getNode() : row.getNode(selector);
                if (node == null) continue;
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("path", node.getPath());
                attr.addCDATAAttribute("pathWithGroups", NodeGroupHelper.getPathWithGroups(node));
                attr.addCDATAAttribute("name", node.getName());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"result", (Attributes)attr);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Unable to execute query '" + query + "'", (Throwable)e);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"error", (String)e.toString());
        }
    }
}

