/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.workspaces.repository.jcr.AbstractRepositoryGenerator;
import org.ametys.workspaces.repository.jcr.NodeStateTracker;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SessionInformationGenerator
extends AbstractRepositoryGenerator {
    protected NodeStateTracker _nodeStateTracker;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._nodeStateTracker = (NodeStateTracker)((Object)serviceManager.lookup(NodeStateTracker.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String workspaceName = this.parameters.getParameter("workspace", "default");
        this._getRepository(request, workspaceName);
        this.contentHandler.startDocument();
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("hasPendingChanges", Boolean.toString(this._session.hasPendingChanges()));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"session", (Attributes)attrs);
            this.generateNewNodes(workspaceName);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"session");
        }
        catch (RepositoryException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
        this.contentHandler.endDocument();
    }

    protected void generateNewNodes(String workspaceName) throws SAXException {
        Set<String> newNodes = this._nodeStateTracker.getNewNodes(workspaceName);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"new-nodes");
        for (String newNodePath : newNodes) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("path", newNodePath);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"node", (Attributes)attrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"new-nodes");
    }
}

