/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.slf4j.Logger;

public abstract class AbstractMaintenanceTask
implements LogEnabled {
    protected ContainerProgressionTracker _progress;
    protected Logger _logger;
    private boolean _isFinished;
    private RepositoryConfig _repositoryConfig;
    private RepositoryContext _repositoryContext;

    public boolean requiresOffline() {
        return true;
    }

    public void execute(Pair<RepositoryConfig, RepositoryContext> repositoryInfo) throws RepositoryException {
        this._repositoryConfig = (RepositoryConfig)repositoryInfo.getLeft();
        this._repositoryContext = (RepositoryContext)repositoryInfo.getRight();
        long startTime = System.currentTimeMillis();
        this.setLogger();
        this._logger.info("Executing task.");
        try {
            this.initialize();
            this.apply();
            this.setFinished();
        }
        catch (Exception e) {
            this.setInErrorState(e);
            throw e;
        }
        finally {
            this.close();
            this._logger.info("End of the task.");
            long elapsedTime = System.currentTimeMillis() - startTime;
            this._logger.info("Done in " + this._getFormattedDuration(elapsedTime));
        }
    }

    protected void initialize() throws RepositoryException {
    }

    protected abstract void apply() throws RepositoryException;

    protected void close() {
        if (this._repositoryConfig != null && this._repositoryContext != null && this._repositoryContext.getRepository() != null) {
            this._logger.info("Shutting down the repository created for maintenance operation");
            this._repositoryContext.getRepository().shutdown();
        }
    }

    protected abstract void setLogger();

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public Map<String, Object> getProgressInfo() {
        if (this._progress != null) {
            return this._progress.toJSON();
        }
        return null;
    }

    public boolean isFinished() {
        return this._isFinished;
    }

    private synchronized void setFinished() {
        this._isFinished = true;
    }

    private synchronized void setInErrorState(Exception e) {
        this._logger.error(e.getLocalizedMessage(), (Throwable)e);
        this._isFinished = true;
    }

    protected String _getFormattedDuration(long elapsedTime) {
        String formatted = DateUtils.formatDuration((long)elapsedTime);
        return (String)StringUtils.defaultIfEmpty((CharSequence)formatted, (CharSequence)"0s");
    }

    protected RepositoryConfig getRepositoryConfig() {
        if (this._repositoryConfig != null) {
            return this._repositoryConfig;
        }
        return this._repositoryContext.getRepositoryConfig();
    }

    protected RepositoryContext createRepositoryContext() throws RepositoryException {
        if (this._repositoryConfig != null && this._repositoryContext == null) {
            this._logger.info("Creating repository for maintenance operation");
            this._repositoryContext = RepositoryContext.create((RepositoryConfig)this._repositoryConfig);
            return this._repositoryContext;
        }
        this._logger.error("Trying to instanciate a new repository when a repository is already existing");
        throw new IllegalStateException("Trying to instanciate a new repository when a repository is already existing");
    }

    protected RepositoryContext getOrCreateRepositoryContext() throws RepositoryException {
        if (this._repositoryContext == null) {
            return this.createRepositoryContext();
        }
        return this._repositoryContext;
    }

    protected RepositoryImpl getRepository() {
        return this._repositoryContext.getRepository();
    }

    protected RepositoryImpl createRepository() throws RepositoryException {
        return this.createRepositoryContext().getRepository();
    }

    protected RepositoryImpl getOrCreateRepository() throws RepositoryException {
        return this.getOrCreateRepositoryContext().getRepository();
    }

    protected static List<IterablePersistenceManager> getAllPersistenceManager(RepositoryContext context) throws RepositoryException {
        String[] wspNames;
        ArrayList<IterablePersistenceManager> pmList = new ArrayList<IterablePersistenceManager>();
        InternalVersionManagerImpl vm = context.getInternalVersionManager();
        PersistenceManager persistenceManager = vm.getPersistenceManager();
        if (!(persistenceManager instanceof IterablePersistenceManager)) {
            return null;
        }
        IterablePersistenceManager versionPersistenceManager = (IterablePersistenceManager)persistenceManager;
        pmList.add(versionPersistenceManager);
        for (String wspName : wspNames = context.getWorkspaceManager().getWorkspaceNames()) {
            PersistenceManager persistenceManager2 = context.getWorkspaceInfo(wspName).getPersistenceManager();
            if (!(persistenceManager2 instanceof IterablePersistenceManager)) {
                return null;
            }
            IterablePersistenceManager iterablePersistenceManager = (IterablePersistenceManager)persistenceManager2;
            pmList.add(iterablePersistenceManager);
        }
        return pmList;
    }
}

