/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.check.ReportItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckTask
extends AbstractMaintenanceTask
implements ConsistencyCheckListener {
    protected Session _session;
    private List<IterablePersistenceManager> _pmList;

    @Override
    protected void initialize() throws RepositoryException {
        RepositoryContext repositoryContext = this.createRepositoryContext();
        this._session = repositoryContext.getRepository().login((Credentials)new SimpleCredentials("__MAINTENANCE_TASK__", "".toCharArray()));
        this._pmList = ConsistencyCheckTask.getAllPersistenceManager(repositoryContext);
        int count = 0;
        try {
            for (IterablePersistenceManager pm : this._pmList) {
                count += pm.getAllNodeIds(null, 0).size();
            }
            this._progress = ProgressionTrackerFactory.createContainerProgressionTracker((I18nizableText)new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_BUTTON_MAINTENANCE_CONSISTENCYCHECK"), (Logger)this._logger);
            this._progress.setSize((long)(count + 1));
        }
        catch (Exception e) {
            this._progress.setSize(0L);
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(ConsistencyCheckTask.class));
    }

    @Override
    protected void apply() throws RepositoryException {
        for (PersistenceManager persistenceManager : this._pmList) {
            if (!(persistenceManager instanceof AbstractBundlePersistenceManager)) continue;
            AbstractBundlePersistenceManager abpm = (AbstractBundlePersistenceManager)persistenceManager;
            ConsistencyReport report = abpm.check(null, true, false, null, (ConsistencyCheckListener)this);
            int numberOfNodesChecked = report.getNodeCount();
            this._logger.info("Consistency check done for persistence manager : '" + persistenceManager.toString() + "' in " + (float)report.getElapsedTimeMs() / 1000.0f + " s.");
            this._logger.info(numberOfNodesChecked + " nodes were checked.");
            this._logger.info((String)(report.getItems().isEmpty() ? "No consistency problems were reported." : report.getItems().size() + " consistency problems were reported."));
            this._progress.increment((long)numberOfNodesChecked);
        }
    }

    @Override
    protected void close() {
        if (this._session != null) {
            this._session.logout();
        }
        super.close();
        if (this._progress != null) {
            this._progress.increment();
        }
    }

    public void startCheck(String id) {
    }

    public void report(ReportItem item) {
        this._logger.warn(item.toString());
    }

    public void error(String id, String message) {
        this._logger.error("error during the consistency check -> id : [ " + id + "]\n" + message);
    }

    public void info(String id, String message) {
        this._logger.info("error during the consistency check -> id : [ " + id + "]\n" + message);
    }
}

