/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.sql.DataSource;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.api.management.MarkEventListener;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.apache.jackrabbit.core.data.db.DerbyDataStore;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreGarbageCollectorTask
extends AbstractMaintenanceTask
implements MarkEventListener {
    private static final int SYSTEM_GC_CALLS = 3;
    protected Session _session;
    private GarbageCollector _garbageCollector;
    private List<IterablePersistenceManager> _pmList;
    private int _scannedNodesCount;

    @Override
    protected void initialize() throws RepositoryException {
        RepositoryContext repositoryContext = this.createRepositoryContext();
        this._session = repositoryContext.getRepository().login((Credentials)new SimpleCredentials("__MAINTENANCE_TASK__", "".toCharArray()));
        this._garbageCollector = repositoryContext.getRepository().createDataStoreGarbageCollector();
        this._pmList = DataStoreGarbageCollectorTask.getAllPersistenceManager(repositoryContext);
        int count = 0;
        try {
            for (IterablePersistenceManager pm : this._pmList) {
                count += pm.getAllNodeIds(null, 0).size();
            }
            this._progress = ProgressionTrackerFactory.createContainerProgressionTracker((I18nizableText)new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_BUTTON_MAINTENANCE_STARTGARBAGECOLLECTOR"), (Logger)this._logger);
            SimpleProgressionTracker progressTrackerForScan = this._progress.addSimpleStep("scan", new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_MAINTENANCE_STARTGARBAGECOLLECTOR_SCAN_STEP_LABEL"), 7.0).withLoggerGranularity(10000);
            progressTrackerForScan.setSize((long)count);
            this._progress.addSimpleStep("deletingunuseditems", new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_MAINTENANCE_STARTGARBAGECOLLECTOR_DELETE_UNUSED_ITEMS_STEP_LABEL"), 2.0);
            SimpleProgressionTracker progressTrackerForFinishing = this._progress.addSimpleStep("finishing", new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_MAINTENANCE_STARTGARBAGECOLLECTOR_FINISH_STEP_LABEL"));
            progressTrackerForFinishing.setSize(2L);
        }
        catch (Exception e) {
            this._progress.setSize(0L);
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(DataStoreGarbageCollectorTask.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void apply() throws RepositoryException {
        for (int i = 0; i < 3; ++i) {
            System.gc();
        }
        long startSize = this._reportDataStoreInfo(this._garbageCollector.getDataStore());
        if (this._garbageCollector.getDataStore() instanceof FileDataStore) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this._logger.error(e.getLocalizedMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this._garbageCollector.setMarkEventListener((MarkEventListener)this);
        this._garbageCollector.setPersistenceManagerScan(true);
        try {
            this._scannedNodesCount = 0;
            this._garbageCollector.mark();
            this._logger.info(this._scannedNodesCount + " nodes scanned.");
            int deleted = this._garbageCollector.sweep();
            this._logger.info(deleted + " unused items deleted.");
            ((SimpleProgressionTracker)this._progress.getStep("deletingunuseditems")).increment();
            if (this._garbageCollector.getDataStore() instanceof DerbyDataStore) {
                this._logger.info("Reclaiming unused space, this may take several minutes depending on the size of the data store.");
                this._logger.info("Please be patient.");
                DbDataStore ds = (DbDataStore)this._garbageCollector.getDataStore();
                DataSource dataSource = this._getDataSource(ds);
                String table = ds.getTablePrefix() + ds.getSchemaObjectPrefix() + "DATASTORE";
                DataStoreGarbageCollectorTask.derbyCompressTable(dataSource, table, this._logger);
            }
        }
        finally {
            this._garbageCollector.close();
            ((SimpleProgressionTracker)this._progress.getStep("finishing")).increment();
        }
        long finalSize = this._reportDataStoreInfo(this._garbageCollector.getDataStore());
        long freedSize = startSize - finalSize;
        this._logger.info("Size of cleared data: " + FileUtils.byteCountToDisplaySize((long)freedSize) + "Ko");
        this._logger.info("The total released space on your disk can be different depending on the type of the data store used by your repository.");
    }

    @Override
    protected void close() {
        if (this._session != null) {
            this._session.logout();
        }
        super.close();
        if (this._progress != null) {
            ((SimpleProgressionTracker)this._progress.getStep("finishing")).increment();
        }
    }

    private long _reportDataStoreInfo(DataStore ds) throws DataStoreException {
        long count = 0L;
        long total = 0L;
        Iterator it = ds.getAllIdentifiers();
        while (it.hasNext()) {
            ++count;
            DataIdentifier id = (DataIdentifier)it.next();
            total += ds.getRecord(id).getLength();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Datastore item count: ").append(count).append(" ");
        sb.append("[total size: ").append(FileUtils.byteCountToDisplaySize((long)total)).append("]");
        this._logger.info(sb.toString());
        return total;
    }

    protected DataSource _getDataSource(DbDataStore ds) throws RepositoryException {
        DataSource dataSource = null;
        try {
            ConnectionFactory cf = this.getRepositoryConfig().getConnectionFactory();
            dataSource = ds.getDataSourceName() == null || "".equals(ds.getDataSourceName()) ? cf.getDataSource(ds.getDriver(), ds.getUrl(), ds.getUser(), ds.getPassword()) : cf.getDataSource(ds.getDataSourceName());
        }
        catch (SQLException e) {
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            this._logger.warn("Failed to retrieve the data source from data store " + ds.getUrl(), (Throwable)e);
            throw e;
        }
        return dataSource;
    }

    public static void derbyCompressTable(DataSource dataSource, String table, Logger logger) {
        ConnectionHelper conHelper = new ConnectionHelper(dataSource, false);
        String sql = "CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(CURRENT SCHEMA, ?, 0)";
        try {
            conHelper.query(sql, new Object[]{table});
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void beforeScanning(Node n) throws RepositoryException {
        ++this._scannedNodesCount;
        if (this._progress != null) {
            ((SimpleProgressionTracker)this._progress.getStep("scan")).increment();
        }
    }
}

