/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.io.File;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexingTask
extends AbstractMaintenanceTask {
    private static final String _INDEX_FOLDER_RELATIVE_PATH = "repository" + File.separator + "index";
    private static final String _WORKSPACES_FOLDER_RELATIVE_PATH = "workspaces";
    private String[] _workspaceFolders;

    @Override
    protected void initialize() throws RepositoryException {
        File file = new File(this.getRepositoryConfig().getHomeDir() + File.separator + _WORKSPACES_FOLDER_RELATIVE_PATH);
        this._workspaceFolders = file.list((f, name) -> f.isDirectory());
        this._progress = ProgressionTrackerFactory.createContainerProgressionTracker((I18nizableText)new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_BUTTON_MAINTENANCE_REINDEXING"), (Logger)this._logger);
        SimpleProgressionTracker progressTrackerForScan = this._progress.addSimpleStep("deletefolders", new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_MAINTENANCE_REINDEXING_DELETE_FOLDERS_STEP_LABEL"), 6.0);
        progressTrackerForScan.setSize((long)(this._workspaceFolders.length + 1));
        this._progress.addSimpleStep("reindexing", new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_BUTTON_MAINTENANCE_REINDEXING"), 3.9);
        this._progress.addSimpleStep("finishing", new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_MAINTENANCE_REINDEXING_SHUTING_DOWN_REPOSITORY_STEP_LABEL"), 0.1);
    }

    @Override
    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(ReindexingTask.class));
    }

    @Override
    protected void apply() throws RepositoryException {
        try {
            this.deleteIndexFolder(_INDEX_FOLDER_RELATIVE_PATH);
            this._logger.info("Successfully deleted root repository index folder");
        }
        catch (IOException e) {
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        for (String folder : this._workspaceFolders) {
            try {
                this.deleteIndexFolder(_WORKSPACES_FOLDER_RELATIVE_PATH + File.separator + folder + File.separator + "index");
                this._logger.info("Successfully deleted index folder of workspace '" + folder + "'");
            }
            catch (IOException e) {
                this._logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this._logger.info("Starting repository to launch the re-indexing process");
        RepositoryImpl repository = this.createRepository();
        this._logger.info("Repository restarted successfully, reindexing process has ended.");
        ((SimpleProgressionTracker)this._progress.getStep("reindexing")).increment();
        repository.shutdown();
        repository = null;
        ((SimpleProgressionTracker)this._progress.getStep("finishing")).increment();
    }

    private void deleteIndexFolder(String relativePath) throws IOException {
        File dir = new File(this.getRepositoryConfig().getHomeDir() + File.separator + relativePath);
        FileUtils.deleteDirectory((File)dir);
        if (this._progress != null) {
            ((SimpleProgressionTracker)this._progress.getStep("deletefolders")).increment();
        }
    }
}

