/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import javax.jcr.version.VersionHistory;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.plugins.repositoryapp.jcr.VersionHistoryHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveUnusedHistoryTask
extends AbstractMaintenanceTask {
    protected RepositoryImpl _repository;

    @Override
    public boolean requiresOffline() {
        return false;
    }

    @Override
    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(RemoveUnusedHistoryTask.class));
    }

    @Override
    protected void apply() throws RepositoryException {
        Map<String, Session> sessions = null;
        SimpleCredentials credentials = new SimpleCredentials("ametys", new char[0]);
        try {
            this._repository = this.getOrCreateRepository();
            String[] accessibleWorkspaceNames = this._getWorkspaces((Credentials)credentials);
            sessions = this._loadSessions(accessibleWorkspaceNames);
            Query q = sessions.get("default").getWorkspace().getQueryManager().createQuery("//element(*, nt:versionHistory)", "xpath");
            NodeIterator nodes = q.execute().getNodes();
            long size = nodes.getSize();
            this._logger.info("Found " + size + " total version histories");
            this._progress = ProgressionTrackerFactory.createContainerProgressionTracker((I18nizableText)new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_BUTTON_MAINTENANCE_STARTREMOVEUNUSEDHISTORY"), (Logger)this._logger);
            this._progress.setSize(size);
            this._removeUnusedHistory(sessions, nodes, size);
        }
        catch (RepositoryException e) {
            if (this._progress != null) {
                this._progress.setSize(0L);
            }
            throw e;
        }
        catch (Exception e) {
            if (this._progress != null) {
                this._progress.setSize(0L);
            }
            throw new RuntimeException(e);
        }
        finally {
            this._logout(sessions);
        }
    }

    private void _logout(Map<String, Session> sessions) {
        if (sessions != null) {
            for (Session session : sessions.values()) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] _getWorkspaces(Credentials credentials) throws RepositoryException {
        Session session = null;
        try {
            session = this._repository.login(credentials, "default");
            String[] stringArray = session.getWorkspace().getAccessibleWorkspaceNames();
            return stringArray;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private Map<String, Session> _loadSessions(String[] accessibleWorkspaceNames) throws RepositoryException {
        HashMap<String, Session> sessions = new HashMap<String, Session>();
        SimpleCredentials credentials = new SimpleCredentials("ametys", new char[0]);
        for (String workspaceName : accessibleWorkspaceNames) {
            sessions.put(workspaceName, this._repository.login((Credentials)credentials, workspaceName));
        }
        return sessions;
    }

    private void _removeUnusedHistory(Map<String, Session> sessions, NodeIterator nodes, long size) throws RepositoryException {
        int errors = 0;
        int done = 0;
        int empty = 0;
        int fixed = 0;
        int count = 0;
        while (nodes.hasNext()) {
            VersionHistoryHelper.RemoveHistoryResult result = VersionHistoryHelper.removeUnusedHistory(sessions, (VersionHistory)nodes.next(), this._logger);
            switch (result) {
                case ERROR: {
                    ++errors;
                    break;
                }
                case FIXED: {
                    ++fixed;
                    break;
                }
                case REMOVED: {
                    ++done;
                    break;
                }
                case UNFIXABLE: {
                    ++empty;
                    break;
                }
            }
            if (++count % 500 == 0) {
                this._logger.info("{}/{} version histories handled, {} removed, {} fixed, {} unfixable, {} unconsistents", new Object[]{count, size, done, fixed, empty, errors});
            }
            this._progress.increment();
        }
        this._logger.info("{} normal history nodes removed\n{} empty history nodes fixed and removed\n{} empty history nodes that are unfixable\n{} unconsistents history nodes that cannot be removed", new Object[]{done, fixed, empty, errors});
    }
}

