/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Represents the repository application, responsible for managing some application-wide variables,
 * such as current workspace and default node sort order.
 * @private
 */
Ext.define('Ametys.repository.RepositoryApp',
{
    singleton: true,
    
    /**
     * The default node sort order.
     * @type {String}
     * @private
     */
    _defaultSort: 'document',
    
    /**
     * The current repository workspace.
     * @type {String}
     * @private
     */
    _currentWorkspace: null,
    
    /**
     * Get the default node sort order.
     * @return {String} the default node sort order.
     */
    getDefaultSort: function()
    {
        return this._defaultSort;
    },
    
    /**
     * Set the default node sort order.
     * @param {String} defaultSort the default node sort order.
     */
    setDefaultSort: function(defaultSort)
    {
        this._defaultSort = defaultSort;
    },
    
    /**
     * Get the current repository workspace.
     * @return {String} the default node sort order.
     */
    getCurrentWorkspace: function()
    {
        return this._currentWorkspace;
    },
    
    /**
     * Set the current repository workspace.
     * @param {String} workspace the new workspace.
     */
    setCurrentWorkspace: function(workspace)
    {
        this._currentWorkspace = workspace;
    },
    
    /**
     * Initialize the application (get repository info).
     */
    initialize: function()
    {
        // Get the connection status and info on the current environment.
        Ametys.data.ServerComm.callMethod({
            role: 'org.ametys.workspaces.repository.jcr.RepositoryDao', 
            methodName: 'getRepositoryInfo', 
            callback: {
                handler: this._initializeCb,
                scope: this
            },
            priority: Ametys.data.ServerComm.PRIORITY_MAJOR
        });
    },
    
    /**
     * Initialize the environment from the response.
     * @param {Object} info The action result.
     * @param {Object} args The callback arguments.
     */
    _initializeCb: function(info, args)
    {
        // Set the default sort order.
        if (info.defaultOrder)
        {
            this.setDefaultSort(info.defaultOrder);
        }
    }
    
});

Ametys.repository.RepositoryApp.initialize();
