/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon menu representing the sort status of a node.
 */
Ext.define('Ametys.repository.controller.NodeSortMenuController',
{
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    constructor: function()
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.SELECTION_CHANGED, this._onMessageSelectionChanged, this);
        Ametys.message.MessageBus.on('repository-node-sorted', this._onNodeSorted, this);
    },
    
    /**
     * Called when the selection has changed.
     * @param {Ametys.message.Message} message The bus message.
     * @protected
     */
    _onMessageSelectionChanged: function(message)
    {
        var target = message.getTarget(Ametys.message.Message.REPOSITORY_NODE);
        if (target != null)
        {
            this._updateMenu(target);
        }
    },
    
    /**
     * Called when a node is sorted.
     * @param {Ametys.message.Message} message The bus message.
     * @protected
     */
    _onNodeSorted: function(message)
    {
        var target = message.getTarget(Ametys.message.Message.REPOSITORY_NODE);
        if (target != null)
        {
            var newOrder = message.getParameters().order;
            this._updateMenuUI(newOrder);
        }
    },
    
    /**
     * Update the button state.
     * @param {Object} target the current selection target.
     * @private
     */
    _updateMenu: function(target)
    {
        var store = Ametys.repository.RepositoryDao.getNodeStore();
        var nodes = store.query('path', target.getParameters().path, false, false, true);
        if (nodes.length > 0)
        {
            var order = nodes.getAt(0).get('order');
            if (order == null)
            {
                order = Ametys.repository.RepositoryApp.getDefaultSort();
            }
            
            this._updateMenuUI(order);
        }
        
        if (target.getParameters().hasOrderableChildNodes)
        {
        	this.enable();
        }
        else
        {
        	this.disable();
        }
    },
    
    /**
     * Update the menu UI.
     * @param {String} newOrder the node new sort order.
     * @private
     */
    _updateMenuUI: function(newOrder)
    {
        var menuItems = this['menu-items'];
        for (var i = 0; i < menuItems.length; i++)
        {
            var item = Ametys.ribbon.RibbonManager.getUI(menuItems[i]);
            if (item != null && item.getInitialConfig('order') == newOrder)
            {
                this.setDescription(item.getInitialConfig('description'));
                this.setGlyphIcon(item.getInitialConfig('icon-glyph'));
            }
        }
    }

});
