/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Abstract base class for tool dealing with the repository.
 * These tools are automatically closed if a maintenance task is launched. 
 * @private
 */
Ext.define('Ametys.repository.tool.RepositoryTool', {
    extend: 'Ametys.tool.Tool',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        // Bus messages listeners
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._closeOnMaintenance, this);
    },
    
    /**
	 * Called on each modified message. Looks for
	 * {@link Ametys.message.MessageTarget#APPLICATION} message target, and
	 * closes the tool if status 'REPOSITORY_UNAVAILABLE' is present.
	 * @param {Ametys.message.Message} message The bus message.
	 * @private
	 */
    _closeOnMaintenance: function(message)
    {
        var target = message.getTarget(Ametys.message.MessageTarget.APPLICATION, 1);
        if (target)
        {
            if (Ext.Array.contains(target.getParameters().status.current || [], 'REPOSITORY_UNAVAILABLE'))
            {
                this.close();
            }
        }
    }
});
