<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="plugin:core://stylesheets/helper/common.xsl"/> 
    
    <xsl:param name="contextPath"/>
    <xsl:param name="workspaceName"/>
    <xsl:param name="workspaceURI"/>
    
    <xsl:template match="/">
        <xsl:variable name="formHeight" select="'350'"/>
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <meta http-equiv="X-UA-Compatible" content="IE=8" />
                <title>
                    <i18n:text i18n:key="APPLICATION_PRODUCT_LABEL" i18n:catalogue="application"/>
                    <i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_LABEL" i18n:catalogue="workspace.{$workspaceName}"/>
                </title>

                <link rel="icon" type="image/x-icon" href="{$contextPath}/favicon.ico" />
                <link rel="shortcut icon" type="image/x-icon" href="{$contextPath}/favicon.ico" />
                
                <style type="text/css" media="screen">
                    body {background: url("<xsl:value-of select="$contextPath"/>/plugins/core-ui/resources/img/Ametys/common/bg.jpg") repeat-x left top #033059; font-family: "Verdana",Arial,Helvetica,sans-serif; font-size: 76%; color: #000; }
                    
                    .bdx-top {font-family: "Arial"; height: 142px; margin-left: auto; margin-right: auto; overflow: hidden; width: 860px;}
                    .bdx-top h1 {color: #812281; font-size: 2.5em; padding-top: 40px; margin-left: 190px; }
                    
                    .form-connection {width: 730px; height: 360px; margin-right: auto; margin-left: auto; margin-top: 80px; padding: 15px 40px 15px 40px; } 
                    .form-connection p {text-align: center; margin-bottom: 20px}
                    .form-connection .input {clear: left; margin-bottom: 10px;}
                    .form-connection .input label {float: left; width: 120px;}
                    .form-connection .button {text-align: center}
                    .form-connection .error {color: #9f0000; font-style:italic;}
                    .form-connection .transp {z-index: -1; background-color: #FFF; filter:alpha(opacity=30); opacity: 0.3; position: absolute; width: 570px; margin-top: 1px; margin-left: 80px; height: <xsl:value-of select="$formHeight"/>px}
                    .form-connection form {color: #333; font-size: 0.9em; width: 530px; height: <xsl:value-of select="$formHeight - 40"/>px; padding: 20px; margin-right: auto; margin-left: auto; border: 1px solid #666; }
                    .form-connection form fieldset {margin-bottom:10px}
                    .form-connection form input.mode {}
                    .form-connection form input.text {color: #333; font-size: 1em; width: 380px}
                    .form-connection form input.button {color: #333; font-size: 1em; }
                 </style> 
                 
                 <xsl:comment>[if IE 7]&gt;
                    &lt;style media="screen"&gt;.transp {margin-left: 0px !important;}&lt;/style&gt;
                 &lt;![endif]</xsl:comment>
            </head>
            
            <body>
                <div class="bdx-top">
                    <div class="logo">
                        <img src="{$contextPath}/plugins/core-ui/resources/img/Ametys/common/logo.png" width="150px" height="124px" style="float:left" alt=""/>
                        <h1>
                            <i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_TITLE" i18n:catalogue="workspace.{$workspaceName}"/>
                            <i18n:text i18n:key="APPLICATION_PRODUCT_LABEL" i18n:catalogue="application"/>
                        </h1>
                    </div>
                </div>
                
                <div id="form-connection" class="form-connection" autocomplete="on">
                    <p><i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_HINT" i18n:catalogue="workspace.{$workspaceName}"/></p>
                    <div class="transp"></div>
                    <form method="post" action="">
                        <fieldset>
                            <legend>
                                <input class="mode" type="radio" name="mode" value="jackrabbit" checked="checked"/>
                                <span><i18n:text i18n:key="WORKSPACE_REPOSITORY_JACKRABBIT_REPOSITORY_RADIO_LABEL" i18n:catalogue="workspace.{$workspaceName}"/></span>
                            </legend>
                            <div class="input">
                                <label for="repository-path"><i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_REPOSITORY_PATH_LABEL" i18n:catalogue="workspace.{$workspaceName}"/></label>
                                <input class="text" type="text" name="repository-path" id="repository-path" autocomplete="on"/>
                            </div>
                            <div class="input">
                                <label for="repository-xml"><i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_REPOSITORY_XML_PATH_LABEL" i18n:catalogue="workspace.{$workspaceName}"/></label>
                                <input class="text" type="text" name="repository-xml" id="repository-xml" autocomplete="on"/>
                            </div>
                            <div class="input">
                                <label for="jackrabbit-user"><i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_REPOSITORY_USER_LABEL" i18n:catalogue="workspace.{$workspaceName}"/></label>
                                <input class="text" type="text" name="user" id="jackrabbit-user" autocomplete="on"/>
                            </div>
                            <div class="input">
                                <label for="jackrabbit-password"><i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_REPOSITORY_PWD_LABEL" i18n:catalogue="workspace.{$workspaceName}"/></label>
                                <input class="text" type="password" name="password" id="jackrabbit-password" autocomplete="on"/>
                            </div>
                        </fieldset>
                        <fieldset>
                            <legend>
                                <input class="mode" type="radio" name="mode" value="jndi"/>
                                <i18n:text i18n:key="WORKSPACE_REPOSITORY_JNDI_RADIO_LABEL" i18n:catalogue="workspace.{$workspaceName}"/>
                            </legend>
                            <div class="input">
                                <label for="jndi-context"><i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_REPOSITORY_CONTEXT_LABEL" i18n:catalogue="workspace.{$workspaceName}"/></label>
                                <input class="text" type="text" name="jndi-context" id="jndi-context" autocomplete="on"/>
                            </div>
                            <div class="input">
                                <label for="jndi-user"><i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_REPOSITORY_USER_LABEL" i18n:catalogue="workspace.{$workspaceName}"/></label>
                                <input class="text" type="text" name="user" id="jndi-user" autocomplete="on"/>
                            </div>
                            <div class="input">
                                <label for="jndi-password"><i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_REPOSITORY_PWD_LABEL" i18n:catalogue="workspace.{$workspaceName}"/></label>
                                <input class="text" type="text" name="password" id="jndi-password" autocomplete="on"/>
                            </div>
                        </fieldset>
                        
                        <xsl:if test="/ActionResult/result = 'error'">
                            <span class="error">
                                <i18n:text i18n:key="WORKSPACE_REPOSITORY_CONNECT_ERROR" i18n:catalogue="workspace.{$workspaceName}"/>
                            </span>
                            <br/><br/>
                        </xsl:if>
                        
                        <div class="button">
                            <input type="submit" class="button" value="workspace.{$workspaceName}:WORKSPACE_REPOSITORY_CONNECT_BUTTON" i18n:attr="value"/>
                        </div>
                    </form>
                </div>
            </body>
        </html>
    </xsl:template>
    
</xsl:stylesheet>
