/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repositoryapp;

import java.util.Map;

import javax.jcr.Session;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;


/**
 * Listens session destruction to ensure that the JCR sessions are properly logged out.
 */
public class JCRRepositorySessionListener implements HttpSessionListener
{

    @Override
    public void sessionCreated(HttpSessionEvent se)
    {
        // Ignore the session creation.
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public void sessionDestroyed(HttpSessionEvent se)
    {
        HttpSession httpSession = se.getSession();
        
        Map<String, Session> jcrSessions = (Map<String, Session>) httpSession.getAttribute(RepositoryProvider.SESSION_JCR_SESSIONS_KEY);
        
        if (jcrSessions != null)
        {
            for (Session session : jcrSessions.values())
            {
                session.logout();
            }
        }
    }
}
