/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repositoryapp.authentication;

import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

/**
 * Authentication for the repository application looking for the administrator login and password.
 */
//FIXME
public class AdminRepositoryAuthentication extends AbstractLogEnabled implements RepositoryAuthentication, Contextualizable
{
    /** Location of the administrator password relative to ametys home */
    public static final String ADMINISTRATOR_PASSWORD_FILENAME = "administrator/admin.xml";
    /** The request attribute name for telling that super user is logged in. */
    public static final String REQUEST_ATTRIBUTE_SUPER_USER = "Runtime:SuperUser";
    
    /** The cocoon context, initialized during the contextualize method */
//    private org.apache.avalon.framework.context.Context _context;
    
    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException
    {
//        _context = context;
    }

//    @Override
//    public CredentialsProvider getCredentialsProvider()
//    {
//        return new BasicCredentialsProvider("Administration", _context);
//    }
//    
//    /**
//     * Set the "Super User" in request attribute 
//     */
//    @Override
//    public void allowed()
//    {
//        Request request = ContextHelper.getRequest(_context);
//        request.setAttribute(AdminAuthenticateAction.REQUEST_ATTRIBUTE_SUPER_USER, Boolean.TRUE);
//    }
//    
//    @Override
//    public boolean allowUser(Credentials credentials)
//    {
//        String login = credentials.getLogin();
//        String passwd = credentials.getPassword();
//
//        try
//        {
//            if (!"admin".equals(login))
//            {
//                if (getLogger().isDebugEnabled())
//                {
//                    getLogger().debug("The administrator login must be 'admin' => authentication failed");
//                }
//                return false;
//            }
//
//            if (passwd == null)
//            {
//                if (getLogger().isDebugEnabled())
//                {
//                    getLogger().debug("The administrator password cannot be null => authentication failed");
//                }
//                return false;
//            }
//
//            try (InputStream is  = new FileInputStream(new File(RuntimeConfig.getInstance().getAmetysHome(), ADMINISTRATOR_PASSWORD_FILENAME)))
//            {
//                XPath xpath = XPathFactory.newInstance().newXPath();
//                String pass = xpath.evaluate("admin/password", new InputSource(is));
//                if (pass == null || "".equals(pass))
//                {
//                    if (getLogger().isWarnEnabled())
//                    {
//                        getLogger().warn("The administrator password cannot be null at reading => authentication failed");
//                    }
//                    return false;
//                }
//
//                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
//                byte[] encryptedPasswd = messageDigest.digest(passwd.getBytes("UTF-8"));
//
//                if (!MessageDigest.isEqual(Base64.decodeBase64(pass.getBytes("UTF-8")), encryptedPasswd))
//                {
//                    if (getLogger().isDebugEnabled())
//                    {
//                        getLogger().debug("The user did not give the right password => authentication failed");
//                    }
//                    return false;
//                }
//
//                return true;
//            }
//            catch (FileNotFoundException e)
//            {
//                if (getLogger().isWarnEnabled())
//                {
//                    String ametysHomePath = RuntimeConfig.getInstance().getAmetysHome().getPath();
//                    getLogger().warn(
//                            "The file '" + ADMINISTRATOR_PASSWORD_FILENAME + "' is missing in Ametys home '" + ametysHomePath
//                                    + "'.\nDefault administrator password 'admin' is used.", e);
//                }
//                
//                return "admin".equals(passwd);
//            }
//        }
//        catch (Exception e)
//        {
//            getLogger().error("Authentication failed", e);
//            return false;
//        }
//    }
}
