/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repositoryapp.ui;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.repositoryapp.RepositoryProvider;

/**
 * Client-side element which tracks the session state.
 */
public class SessionClientSideElement extends StaticClientSideElement
{
    
    /** The repository provider. */
    protected RepositoryProvider _repositoryProvider;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _repositoryProvider = (RepositoryProvider) serviceManager.lookup(RepositoryProvider.ROLE);
    }
    
    /**
     * Test if the session has pending changes.
     * @param workspaceName the workspace name.
     * @return true if the session has pending changes, false otherwise.
     * @throws RepositoryException if an error occurs.
     */
    @Callable(rights = "REPOSITORY_Rights_Access", context = "/repository")
    public boolean hasPendingChanges(String workspaceName) throws RepositoryException
    {
        Session session = _repositoryProvider.getSession(workspaceName);
        
        return session.hasPendingChanges();
    }
    
}
