/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repositoryapp.view;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SAXClientSideElementHelper;

/**
 * SAX the definition of the additional views.
 */
public class RepositoryViewGenerator extends ServiceableGenerator
{
    private RepositoryViewExtensionPoint _repositoryViewExtensionPoint;
    private SAXClientSideElementHelper _saxClientSideElementHelper;
    
    @Override
    public void service(ServiceManager sManager) throws ServiceException
    {
        super.service(manager);
        _repositoryViewExtensionPoint = (RepositoryViewExtensionPoint) sManager.lookup(RepositoryViewExtensionPoint.ROLE);
        _saxClientSideElementHelper = (SAXClientSideElementHelper) sManager.lookup(SAXClientSideElementHelper.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "views");
        
        for (String id : _repositoryViewExtensionPoint.getExtensionsIds())
        {
            ClientSideElement element = _repositoryViewExtensionPoint.getExtension(id);
            _saxClientSideElementHelper.saxDefinition("view", element, RepositoryViewExtensionPoint.ROLE, contentHandler, null);
        }
        
        XMLUtils.endElement(contentHandler, "views");
        contentHandler.endDocument();
    }
}
