/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.workspaces.repository;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.excalibur.source.Source;

import org.ametys.core.ui.ribbonconfiguration.RibbonConfigurationSource;
import org.ametys.core.util.SystemStatus;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.workspaces.repository.maintenance.MaintenanceTaskManager;

/**
 * Repository workspace handling maintenance tasks in safe mode.
 */
public class RepositoryWorkspaceGenerator extends org.ametys.plugins.core.ui.WorkspaceGenerator
{
    /** System status provider */
    protected SystemStatus _systemStatus;
    
    @Override
    protected RibbonConfigurationSource getRibbonConfiguration() throws IOException
    {
        if (PluginsManager.getInstance().isSafeMode())
        {
            return RibbonConfigurationSource.createFromUri("resource://org/ametys/workspaces/repository/repository-safe-ribbon.xml", _resolver);
        }
        
        return super.getRibbonConfiguration();
    }
    
    @Override
    public void service(ServiceManager sm) throws ServiceException
    {
        super.service(sm);
        _systemStatus = (SystemStatus) sm.lookup(SystemStatus.ROLE);
    }
    
    @Override
    protected Source getUIToolsConfiguration() throws IOException
    {
        if (PluginsManager.getInstance().isSafeMode())
        {
            boolean safeModeForced = PluginsManager.Status.SAFE_MODE_FORCED.equals(PluginsManager.getInstance().getStatus());
            if (safeModeForced && _systemStatus.getStatus().contains(MaintenanceTaskManager.REPOSITORY_UNAVAILABLE))
            {
                return _resolver.resolveURI("resource://org/ametys/workspaces/repository/repository-maintenance-uitools.xml");
            }
        }
        
        return super.getUIToolsConfiguration();
    }
}
