/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.workspaces.repository.jcr;

import javax.jcr.Session;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;

import org.ametys.plugins.repositoryapp.RepositoryProvider;

/**
 * Abstract generator dealing with repository
 */
public abstract class AbstractRepositoryGenerator extends ServiceableGenerator
{
    
    /** The JCR repository session */
    protected Session _session;
    
    /** The repository provider. */
    protected RepositoryProvider _repositoryProvider;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _repositoryProvider = (RepositoryProvider) serviceManager.lookup(RepositoryProvider.ROLE);
    }
    
    /**
     * Get the repository and session and set the _repository and _session protected fields
     * @param request The request
     * @param workspaceName The jcr workspace
     * @throws ProcessingException if an error occured
     */
    protected void _getRepository(Request request, String workspaceName) throws ProcessingException
    {
        try
        {
            _session = _repositoryProvider.getSession(workspaceName);
        }
        catch (Exception e)
        {
            throw new ProcessingException(e);
        }
        
    }
}
