/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.workspaces.repository.jcr;

import java.io.IOException;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.repositoryapp.RepositoryProvider;

/**
 * SAX the accessible workspaces
 */
public class WorkspacesGenerator extends ServiceableGenerator
{
    
    /** The repository provider. */
    protected RepositoryProvider _repositoryProvider;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _repositoryProvider = (RepositoryProvider) serviceManager.lookup(RepositoryProvider.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        try
        {
            Session session = _repositoryProvider.getSession("default");
            
            Workspace workspace = session.getWorkspace();
            
            contentHandler.startDocument();
            XMLUtils.startElement(contentHandler, "workspaces");
            
            for (String workspaceName : workspace.getAccessibleWorkspaceNames())
            {
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("name", workspaceName);
                XMLUtils.createElement(contentHandler, "workspace", attrs);
            }
            
            XMLUtils.endElement(contentHandler, "workspaces");
            contentHandler.endDocument();
        }
        catch (RepositoryException e)
        {
            throw new ProcessingException("Unable to get accessible workspaces", e);
        }
    }
}
